#ifndef __GraphicsInclude__
#define __GraphicsInclude__

/**
 * @file GraphicsInclude.h
 * @brief Single include for the graphics package
 *
 * @date 23/08/2004
 * @author Paul Chana
 * @version 1.0.0 Initial version
 *
 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
 * All content is the Intellectual property of Exp Digital Uk.\n
 * Certain sections of this code may come from other sources. They are credited where applicable.\n
 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
 *
 * $Id: GraphicsInclude.h,v 1.6 2007/03/03 02:59:20 paul Exp $
 *
 * @todo Make IImage pure virtual with inheritance
 */

/**
 * @namespace Exponent::GUI::Graphics
 * @brief Main Image and Drawing namespace
 *
 * Drawing and image based routines
 */

#include "CGraphics.hpp"
#include "CBaseImage.hpp"
#include "CBitmapImage.hpp"
#include "CBrush.hpp"
#include "CImageManager.hpp"
#include "CJPEGImage.hpp"
#include "CNativeImage.hpp"
#include "CPen.hpp"
#include "CPNGImage.hpp"
#include "CTGAImage.hpp"
#include "CWindowIcon.hpp"
#include "IImage.hpp"
#include "SGraphicsHandle.hpp"

//	===========================================================================

#ifndef EXPONENT_COMPACT_BUILD
	using namespace Exponent::GUI::Graphics;
#endif

#endif	// GraphicsInclude.h